/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.app;

import android.text.TextUtils;
import com.secure.comm.app.SPApplication;
import com.secure.comm.utils.SPJSONUtil;
import com.secure.comm.utils.SPStringUtil;
import com.secure.comm.utils.SPSystemUtil;
import com.secure.sportal.gateway.GatewayErrorText;
import com.secure.sportal.jni.LibSecurePortal;
import com.secure.sportal.jni.SPLibBridge;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;

public class SPOEM {
    private static final String OEM_NONE = "";
    private static final String OEM_SINA = "sina";
    private static final String OEM_BANKCOMM = "bankcomm";
    private static final String OEM_SINOPEC = "sinopec";
    private static final String OEM_MPOLICY_ZJ = "mpolicy.zj";
    private static final String OEM_GOV_XIANGYANG = "gov.xiangyang";
    private static final String OEM_PROCURATORATE_GX = "procuratorate.guangxi";
    public static final String OEM_MAIN_CNTLS = "main_cntls";
    public static final String OEM_BANK_JYGX = "jygx";

    public static String oemName() {
        return SPApplication.oemName();
    }

    public static synchronized void setOEMName(String oem_name) {
        SPOEM.setOEMName(oem_name, false);
    }

    public static synchronized void setOEMName(String oem_name, boolean sync) {
        if ((oem_name = SPStringUtil.opt(oem_name).toLowerCase(Locale.ENGLISH)).length() > 0) {
            if ("zsh_otp".equals(oem_name)) {
                oem_name = OEM_SINOPEC;
            } else if ("zjga".equalsIgnoreCase(oem_name)) {
                oem_name = OEM_MPOLICY_ZJ;
            } else if ("jtyh".equalsIgnoreCase(oem_name)) {
                oem_name = OEM_BANKCOMM;
            } else if (oem_name.startsWith("jtyh")) {
                oem_name = OEM_BANKCOMM + oem_name.substring(4);
            } else if ("xyzf".equalsIgnoreCase(oem_name)) {
                oem_name = OEM_GOV_XIANGYANG;
            } else if ("gxgj".equalsIgnoreCase(oem_name)) {
                oem_name = OEM_PROCURATORATE_GX;
            }
            if (oem_name.equals(SPOEM.oemName())) {
                return;
            }
            SPApplication.setOEMName(oem_name);
            final JSONObject json = new JSONObject();
            SPJSONUtil.put(json, "name", SPOEM.oemName());
            if (SPOEM.isOEM_Sinopec()) {
                SPJSONUtil.put(json, "vpn_host_ttl", "-1");
            } else if (SPOEM.isOEM_MPolicyZJ()) {
                SPJSONUtil.put(json, "no_tun_filter", "1");
                SPJSONUtil.put(json, "ssl_smx_global", "1");
                SPJSONUtil.put(json, "ssl_smx_cipher", "ECC-SM4-SM3");
                JSONArray messages = new JSONArray();
                JSONObject errmsg = new JSONObject();
                SPJSONUtil.put(errmsg, "errcode", "0x02000404");
                SPJSONUtil.put(errmsg, "cn", "\u8bc1\u4e66\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7f51\u7ba1\u4eba\u5458");
                GatewayErrorText.putErrMsg(0x2000404, "\u8bc1\u4e66\u4fe1\u606f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7f51\u7ba1\u4eba\u5458");
                messages.put((Object)errmsg);
                SPJSONUtil.put(json, "messages", messages);
            } else if (SPOEM.isOEM_Bankcomm() || SPOEM.isOEM_jygx()) {
                SPJSONUtil.put(json, "vpn_host_ttl", "-1");
                SPJSONUtil.put(json, "dns_gateway", "1");
                JSONArray array = new JSONArray();
                SPJSONUtil.put(json, "match_domains", array);
            } else if (OEM_MAIN_CNTLS.equalsIgnoreCase(oem_name)) {
                SPJSONUtil.put(json, "ssl_smx_global", "1");
                SPJSONUtil.put(json, "ssl_smx_cipher", "ECC-SM4-SM3");
            }
            Runnable doer = new Runnable(){

                @Override
                public void run() {
                    if (SPOEM.isOEM_MPolicyZJ()) {
                        LibSecurePortal.systemLoadLibrary("swskf");
                        LibSecurePortal.systemLoadLibrary("safekey");
                        LibSecurePortal.systemLoadLibrary("zdtoken_service_jni");
                        LibSecurePortal.systemLoadLibrary("ZD_sdcard_api");
                        LibSecurePortal.systemLoadLibrary("stdkeyapi");
                        SPSystemUtil.sleepEx(500L);
                    }
                    SPLibBridge.loopbackExeCmdEx("sys_set_oem", json);
                }
            };
            if (sync) {
                doer.run();
            } else {
                new Thread(doer).start();
            }
        }
    }

    public static boolean isOEM_None() {
        return TextUtils.isEmpty((CharSequence)SPOEM.oemName()) || "main".equalsIgnoreCase(SPOEM.oemName());
    }

    public static boolean isOEM_MPolicyZJ() {
        return OEM_MPOLICY_ZJ.equalsIgnoreCase(SPOEM.oemName());
    }

    public static boolean isOEM_Sina() {
        return OEM_SINA.equalsIgnoreCase(SPOEM.oemName());
    }

    public static boolean isOEM_Bankcomm() {
        return OEM_BANKCOMM.equalsIgnoreCase(SPOEM.oemName()) || SPOEM.oemName().startsWith(OEM_BANKCOMM);
    }

    public static boolean isOEM_Sinopec() {
        return OEM_SINOPEC.equalsIgnoreCase(SPOEM.oemName());
    }

    public static boolean isOEM_ProcGuangxi() {
        return OEM_PROCURATORATE_GX.equalsIgnoreCase(SPOEM.oemName());
    }

    public static boolean isOEM_jygx() {
        return OEM_BANK_JYGX.equalsIgnoreCase(SPOEM.oemName());
    }

    public static boolean isHostResolveOnce() {
        return SPOEM.isOEM_Bankcomm() || SPOEM.isOEM_Sinopec();
    }
}

