/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.app;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import java.lang.ref.WeakReference;

public class SPAsyncCallHandler
extends Handler {
    final WeakReference<ContentResolver> mResolver;
    private static Looper sLooper = null;
    private Handler mWorkerThreadHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SPAsyncCallHandler(ContentResolver cr) {
        this.mResolver = new WeakReference<ContentResolver>(cr);
        Class<SPAsyncCallHandler> clazz = SPAsyncCallHandler.class;
        synchronized (SPAsyncCallHandler.class) {
            if (sLooper == null) {
                HandlerThread thread = new HandlerThread("SPAsyncCallWorker");
                thread.start();
                sLooper = thread.getLooper();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mWorkerThreadHandler = new WorkerHandler(sLooper);
            return;
        }
    }

    public void startQuery(int token, Object cookie, Uri uri, String method, String arg, Bundle extras) {
        WorkerArgs args = new WorkerArgs();
        args.handler = this;
        args.cookie = cookie;
        args.uri = uri;
        args.method = method;
        args.arg = arg;
        args.extras = extras;
        Message msg = this.mWorkerThreadHandler.obtainMessage(token, (Object)args);
        this.mWorkerThreadHandler.sendMessage(msg);
    }

    public final void cancelOperation(int token) {
        this.mWorkerThreadHandler.removeMessages(token);
    }

    protected void onCallComplete(int token, Object cookie, Bundle result) {
    }

    public void handleMessage(Message msg) {
        WorkerArgs args = (WorkerArgs)msg.obj;
        this.onCallComplete(msg.what, args.cookie, args.result);
    }

    protected class WorkerHandler
    extends Handler {
        public WorkerHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            ContentResolver resolver = (ContentResolver)SPAsyncCallHandler.this.mResolver.get();
            if (null != resolver) {
                WorkerArgs args = (WorkerArgs)msg.obj;
                args.result = resolver.call(args.uri, args.method, args.arg, args.extras);
                Message reply = args.handler.obtainMessage(msg.what, (Object)args);
                reply.arg1 = msg.arg1;
                reply.sendToTarget();
            }
        }
    }

    protected static final class WorkerArgs {
        public Handler handler;
        public Object cookie;
        public Uri uri;
        public String method;
        public String arg;
        public Bundle extras;
        public Bundle result;

        protected WorkerArgs() {
        }
    }
}

