/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.app;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.secure.PLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SPAppReceiver
extends BroadcastReceiver {
    public static final int ACTION_APP_ADDED = 1;
    public static final int ACTION_APP_REPLACED = 2;
    public static final int ACTION_APP_REMOVED = 4;
    private static List<OnAppChangedListener> listeners = Collections.synchronizedList(new ArrayList());
    private static SPAppReceiver instance = null;

    public static synchronized void startRecv(Context context) {
        if (null == instance) {
            context = context.getApplicationContext();
            try {
                instance = new SPAppReceiver();
                context.registerReceiver((BroadcastReceiver)instance, new IntentFilter());
            }
            catch (Exception ex) {
                PLog.v(ex);
            }
        }
    }

    public static synchronized void stopRecv(Context context) {
        if (null != instance) {
            context = context.getApplicationContext();
            try {
                context.unregisterReceiver((BroadcastReceiver)instance);
            }
            catch (Exception ex) {
                PLog.v(ex);
            }
            instance = null;
            listeners.clear();
        }
    }

    public static void addListener(OnAppChangedListener l) {
        if (!listeners.contains(l)) {
            listeners.add(l);
        }
    }

    public static void removeListener(OnAppChangedListener l) {
        listeners.remove(l);
    }

    public static void clearListener() {
        listeners.clear();
    }

    public void onReceive(Context context, Intent intent) {
        int action = 0;
        if ("android.intent.action.PACKAGE_ADDED".equals(intent.getAction())) {
            action = 1;
        } else if ("android.intent.action.PACKAGE_REPLACED".equals(intent.getAction())) {
            action = 2;
        } else if ("android.intent.action.PACKAGE_REMOVED".equals(intent.getAction())) {
            action = 4;
        }
        String pkgname = intent.getDataString();
        if (action > 0 && null != pkgname) {
            int pos = pkgname.indexOf(":");
            if (pos != -1) {
                pkgname = pkgname.substring(pos + 1);
            }
            for (OnAppChangedListener l : listeners) {
                try {
                    if ((l.getAction() & action) <= 0) continue;
                    l.onAppChanged(action, pkgname);
                }
                catch (Exception ex) {
                    PLog.v(ex);
                }
            }
        }
    }

    public static interface OnAppChangedListener {
        public int getAction();

        public void onAppChanged(int var1, String var2);
    }
}

