/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm.app;

import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import java.util.ArrayList;
import java.util.List;

public class SPAppLifecycleHandler
implements Application.ActivityLifecycleCallbacks,
ComponentCallbacks2 {
    private Context mContext;
    private int mAlives = 0;
    private int mActives = 0;
    private boolean mFirstTime = true;
    private boolean mIsAlive = false;
    private boolean mIsActivated = false;
    private List<OnAppActivateListener> mActivateListeners = new ArrayList<OnAppActivateListener>();
    private List<OnActivityResumeListener> mResumeListeners = new ArrayList<OnActivityResumeListener>();
    private static SPAppLifecycleHandler _instance;
    public static Activity topActivity;
    public static Runnable activedHook;

    public static boolean isActivated() {
        return SPAppLifecycleHandler.instance().mIsActivated;
    }

    public static void registerToApplication(Application app) {
        SPAppLifecycleHandler.unregisterToApplication(app);
        SPAppLifecycleHandler handler = SPAppLifecycleHandler.instance();
        handler.mContext = app.getApplicationContext();
        app.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)handler);
        app.registerComponentCallbacks((ComponentCallbacks)handler);
    }

    public static void unregisterToApplication(Application app) {
        SPAppLifecycleHandler handler = SPAppLifecycleHandler.instance();
        handler.mActives = 0;
        handler.mAlives = 0;
        handler.mIsAlive = false;
        handler.mIsActivated = false;
        app.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)handler);
        app.unregisterComponentCallbacks((ComponentCallbacks)handler);
    }

    public static void addActivateListener(OnAppActivateListener l) {
        SPAppLifecycleHandler handler = SPAppLifecycleHandler.instance();
        if (!handler.mActivateListeners.contains(l)) {
            handler.mActivateListeners.add(l);
        }
    }

    public static void removeActivateListener(OnAppActivateListener l) {
        SPAppLifecycleHandler.instance().mActivateListeners.remove(l);
    }

    public static void addResumeListener(OnActivityResumeListener l) {
        SPAppLifecycleHandler handler = SPAppLifecycleHandler.instance();
        if (!handler.mResumeListeners.contains(l)) {
            handler.mResumeListeners.add(l);
        }
    }

    public static void removeResumeListener(OnActivityResumeListener l) {
        SPAppLifecycleHandler.instance().mResumeListeners.remove(l);
    }

    private static synchronized SPAppLifecycleHandler instance() {
        return null == _instance ? (_instance = new SPAppLifecycleHandler()) : _instance;
    }

    private SPAppLifecycleHandler() {
    }

    private void updateAliveState(boolean isAlive, Activity activity) {
        if (this.mIsAlive != isAlive) {
            this.mIsAlive = isAlive;
        }
    }

    private void updateActivationState(boolean isActivated, Activity activity) {
        if (this.mIsActivated != isActivated) {
            this.mIsActivated = isActivated;
            for (OnAppActivateListener l : this.mActivateListeners) {
                if (this.mIsActivated) {
                    topActivity = activity;
                    l.onAppEnterForeround(activity);
                    continue;
                }
                l.onAppEnterBackground(this.mContext);
            }
            if (null != activedHook) {
                new Thread(activedHook).start();
            }
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        ++this.mAlives;
        this.updateAliveState(this.mAlives > 0, activity);
    }

    public void onActivityStarted(Activity activity) {
        ++this.mActives;
        this.updateActivationState(this.mActives > 0, activity);
    }

    public void onActivityResumed(Activity activity) {
        topActivity = activity;
        if (this.mFirstTime) {
            this.mFirstTime = false;
        }
        for (OnActivityResumeListener l : this.mResumeListeners) {
            l.onActivityResume(activity);
        }
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        this.mActives = Math.max(0, this.mActives - 1);
        this.updateActivationState(this.mActives > 0, activity);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
        this.mAlives = Math.max(0, this.mAlives - 1);
        this.updateAliveState(this.mAlives > 0, activity);
        if (this.mAlives <= 0) {
            topActivity = null;
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
    }

    public void onLowMemory() {
    }

    public void onTrimMemory(int i) {
    }

    public void onPowerOff(Context context) {
    }

    static {
        topActivity = null;
        activedHook = null;
    }

    public static interface OnActivityResumeListener {
        public void onActivityResume(Activity var1);
    }

    public static interface OnAppActivateListener {
        public void onAppEnterForeround(Activity var1);

        public void onAppEnterBackground(Context var1);
    }
}

