/*
 * Decompiled with CFR 0.152.
 */
package com.secure.comm;

import android.text.TextUtils;
import android.util.Log;
import com.secure.comm.utils.SPStringUtil;
import com.secure.sportal.jni.LibSecurePortal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Pattern;

public class SPLog {
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_VERBOSE = 2;
    public static final int LEVEL_DEBUG = 3;
    public static final int LEVEL_INFO = 4;
    public static final int LEVEL_WARN = 5;
    public static final int LEVEL_ERROR = 6;
    public static final int LEVEL_OFF = 8;
    public static int level = 0;
    protected static final String TAG = "vpnclient";
    private static final SimpleDateFormat LOG_TIME_FMT = new SimpleDateFormat("[HH:mm:ss]", Locale.getDefault());
    protected String _tag;
    protected String _prefix;

    public static SPLog getLog(String tag) {
        return new SPLog(tag);
    }

    public static SPLog getLogp(String prefix) {
        return new SPLog(TAG).prefix(prefix);
    }

    public static void setLevelByName(String levelName) {
        String ln = SPStringUtil.opt(levelName).trim().toLowerCase(Locale.ENGLISH);
        if ("all".equals(ln) || "trace".equals(ln) || "verbose".equals(ln)) {
            level = 2;
        } else if ("debug".equals(ln)) {
            level = 3;
        } else if ("info".equals(ln)) {
            level = 4;
        } else if ("warn".equals(ln)) {
            level = 5;
        } else if ("error".equals(ln)) {
            level = 6;
        }
    }

    protected SPLog(String tag) {
        this._tag = TextUtils.isEmpty((CharSequence)tag) ? TAG : tag;
        this._prefix = "";
    }

    public SPLog prefix(String prefix) {
        this._prefix = prefix;
        if (!TextUtils.isEmpty((CharSequence)this._prefix)) {
            this._prefix = ("[" + this._prefix.trim() + "]").replaceAll(Pattern.quote("[["), "[");
            this._prefix = this._prefix.replaceAll(Pattern.quote("]]"), "]").trim() + " ";
        } else {
            this._prefix = "";
        }
        return this;
    }

    private static String format(String fmt, Object[] args) {
        if (null == fmt) {
            return "";
        }
        if (null == args || args.length == 0) {
            return fmt;
        }
        int bufferSize = fmt.length() + (args == null ? 0 : args.length * 10);
        Formatter f = new Formatter(new StringBuilder(bufferSize), Locale.ENGLISH);
        String msg = f.format(fmt, args).toString();
        f.close();
        return msg;
    }

    private String writeLog(String level, String msg, Object[] args, Throwable ex) {
        StringBuilder sb = new StringBuilder();
        sb.append(level).append("[vpncli]").append(this._prefix);
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            if (null != args && args.length > 0) {
                sb.append(SPLog.format(msg, args));
            } else {
                sb.append(msg);
            }
        }
        String body = sb.toString();
        if (null != ex) {
            sb.append(": ").append(ex.toString());
        }
        sb.insert(0, LOG_TIME_FMT.format(new Date()));
        byte[] bytes = sb.toString().getBytes();
        LibSecurePortal.nativeLogWrite(bytes, bytes.length);
        return body;
    }

    public void v(String msg, Object ... args) {
        String mbody = this.writeLog("[trace]", msg, args, null);
        if (level <= 2) {
            Log.i((String)this._tag, (String)mbody);
        }
    }

    public void v(Throwable tr) {
        String mbody = this.writeLog("[trace]", null, null, tr);
        if (level <= 2) {
            Log.i((String)this._tag, (String)mbody, (Throwable)tr);
        }
    }

    public void v(String msg, Throwable tr) {
        String mbody = this.writeLog("[trace]", msg, null, tr);
        if (level <= 2) {
            Log.i((String)this._tag, (String)mbody, (Throwable)tr);
        }
    }

    public void d(String msg, Object ... args) {
        String mbody = this.writeLog("[debug]", msg, args, null);
        if (level <= 3) {
            Log.i((String)this._tag, (String)mbody);
        }
    }

    public void d(Throwable tr) {
        String mbody = this.writeLog("[debug]", null, null, tr);
        if (level <= 3) {
            Log.i((String)this._tag, (String)mbody, (Throwable)tr);
        }
    }

    public void d(String msg, Throwable tr) {
        String mbody = this.writeLog("[debug]", msg, null, tr);
        if (level <= 3) {
            Log.i((String)this._tag, (String)mbody, (Throwable)tr);
        }
    }

    public void i(String msg, Object ... args) {
        String mbody = this.writeLog("[info ]", msg, args, null);
        if (level <= 4) {
            Log.i((String)this._tag, (String)mbody);
        }
    }

    public void i(Throwable tr) {
        String mbody = this.writeLog("[info ]", null, null, tr);
        if (level <= 4) {
            Log.i((String)this._tag, (String)mbody, (Throwable)tr);
        }
    }

    public void i(String msg, Throwable tr) {
        String mbody = this.writeLog("[info ]", msg, null, tr);
        if (level <= 4) {
            Log.i((String)this._tag, (String)mbody, (Throwable)tr);
        }
    }

    public void w(String msg, Object ... args) {
        String mbody = this.writeLog("[warn ]", msg, args, null);
        if (level <= 5) {
            Log.w((String)this._tag, (String)mbody);
        }
    }

    public void w(Throwable tr) {
        String mbody = this.writeLog("[warn ]", null, null, tr);
        if (level <= 5) {
            Log.w((String)this._tag, (String)mbody, (Throwable)tr);
        }
    }

    public void w(String msg, Throwable tr) {
        String mbody = this.writeLog("[warn ]", msg, null, tr);
        if (level <= 5) {
            Log.w((String)this._tag, (String)mbody, (Throwable)tr);
        }
    }

    public void e(String msg, Object ... args) {
        String mbody = this.writeLog("[error]", msg, args, null);
        if (level <= 6) {
            Log.e((String)this._tag, (String)mbody);
        }
    }

    public void e(Throwable tr) {
        String mbody = this.writeLog("[error]", null, null, tr);
        if (level <= 6) {
            Log.e((String)this._tag, (String)mbody, (Throwable)tr);
        }
    }

    public void e(String msg, Throwable tr) {
        String mbody = this.writeLog("[error]", msg, null, tr);
        if (level <= 6) {
            Log.e((String)this._tag, (String)mbody, (Throwable)tr);
        }
    }
}

