/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.fingerprint;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.KeyguardManager;
import android.content.Context;
import android.support.v4.hardware.fingerprint.FingerprintManagerCompat;
import android.support.v4.os.CancellationSignal;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.DHInterface.StandardFeature;
import io.dcloud.common.util.JSUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class FingerPrintsImpl
extends StandardFeature {
    private FingerprintManagerCompat mFingerprintManager;
    private CancellationSignal mCancellationSignal;

    public String isSupport(IWebview pWebview, JSONArray array) {
        if (this.mFingerprintManager == null) {
            this.mFingerprintManager = FingerprintManagerCompat.from((Context)pWebview.getActivity());
        }
        if (this.isHardwareDetected()) {
            return JSUtil.wrapJsVar((boolean)true);
        }
        return JSUtil.wrapJsVar((boolean)false);
    }

    public String isEnrolledFingerprints(IWebview pWebview, JSONArray array) {
        if (this.mFingerprintManager == null) {
            this.mFingerprintManager = FingerprintManagerCompat.from((Context)pWebview.getActivity());
        }
        if (this.isHasEnrolledFingerprints()) {
            return JSUtil.wrapJsVar((boolean)true);
        }
        return JSUtil.wrapJsVar((boolean)false);
    }

    public String isKeyguardSecure(IWebview pwebview, JSONArray array) {
        if (this.isKeyguardSecure(pwebview.getActivity())) {
            return JSUtil.wrapJsVar((boolean)true);
        }
        return JSUtil.wrapJsVar((boolean)false);
    }

    public void cancel(IWebview pWebview, JSONArray array) {
        this.cancelAuthenticate();
    }

    public void authenticate(final IWebview pWebview, JSONArray array) {
        final String cbid = array.optString(0);
        if (this.mFingerprintManager == null) {
            this.mFingerprintManager = FingerprintManagerCompat.from((Context)pWebview.getActivity());
        }
        if (!this.isHardwareDetected()) {
            this.resultCallback(pWebview, cbid, 1, "no fingerprint device", JSUtil.ERROR, false);
            return;
        }
        if (!this.isHasEnrolledFingerprints()) {
            this.resultCallback(pWebview, cbid, 3, "UNENROLLED", JSUtil.ERROR, false);
            return;
        }
        if (!this.isKeyguardSecure(pWebview.getActivity())) {
            this.resultCallback(pWebview, cbid, 2, "IN SECURE", JSUtil.ERROR, false);
            return;
        }
        this.callFingerPrintVerify(new IFingerprintResultListener(){

            @Override
            public void onAuthenticateError(int errMsgId, CharSequence errString) {
                int nErrorCode = 7;
                if (errMsgId == 5) {
                    nErrorCode = 6;
                } else if (errMsgId == 7) {
                    nErrorCode = 5;
                }
                FingerPrintsImpl.this.resultCallback(pWebview, cbid, nErrorCode, errString.toString(), JSUtil.ERROR, false);
            }

            @Override
            public void onAuthenticateFailed() {
                FingerPrintsImpl.this.resultCallback(pWebview, cbid, 4, "Authenticate not match", JSUtil.ERROR, true);
            }

            @Override
            public void onAuthenticateHelp(int helpMsgId, CharSequence helpString) {
            }

            @Override
            public void onAuthenticateSucceeded(FingerprintManagerCompat.AuthenticationResult result) {
                FingerPrintsImpl.this.resultCallback(pWebview, cbid, 0, "Authenticate Succeeded", JSUtil.OK, false);
            }
        });
    }

    private void resultCallback(IWebview pWebiew, String strCbid, int nErrCode, String resString, int resState, Boolean keepCallback) {
        JSONObject resultObj = new JSONObject();
        try {
            resultObj.put("code", nErrCode);
            resultObj.put("message", (Object)resString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSUtil.execCallback((IWebview)pWebiew, (String)strCbid, (JSONObject)resultObj, (int)resState, (boolean)keepCallback);
    }

    @SuppressLint(value={"NewApi"})
    public void callFingerPrintVerify(final IFingerprintResultListener listener) {
        if (this.mCancellationSignal == null) {
            this.mCancellationSignal = new CancellationSignal();
        }
        try {
            this.mFingerprintManager.authenticate(null, 0, this.mCancellationSignal, new FingerprintManagerCompat.AuthenticationCallback(){

                public void onAuthenticationError(int errMsgId, CharSequence errString) {
                    if (listener != null) {
                        listener.onAuthenticateError(errMsgId, errString);
                    }
                }

                public void onAuthenticationFailed() {
                    if (listener != null) {
                        listener.onAuthenticateFailed();
                    }
                }

                public void onAuthenticationHelp(int helpMsgId, CharSequence helpString) {
                    if (listener != null) {
                        listener.onAuthenticateHelp(helpMsgId, helpString);
                    }
                }

                public void onAuthenticationSucceeded(FingerprintManagerCompat.AuthenticationResult result) {
                    if (listener != null) {
                        listener.onAuthenticateSucceeded(result);
                    }
                }
            }, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint(value={"NewApi"})
    private boolean isHasEnrolledFingerprints() {
        try {
            return this.mFingerprintManager.hasEnrolledFingerprints();
        }
        catch (Exception e) {
            return false;
        }
    }

    @SuppressLint(value={"NewApi"})
    public boolean isHardwareDetected() {
        try {
            return this.mFingerprintManager.isHardwareDetected();
        }
        catch (Exception e) {
            return false;
        }
    }

    @SuppressLint(value={"NewApi"})
    private boolean isKeyguardSecure(Activity activity) {
        try {
            KeyguardManager mKeyManager = (KeyguardManager)activity.getSystemService("keyguard");
            return mKeyManager.isKeyguardSecure();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void cancelAuthenticate() {
        if (this.mCancellationSignal != null) {
            this.mCancellationSignal.cancel();
            this.mCancellationSignal = null;
        }
    }

    public static interface IFingerprintResultListener {
        public void onAuthenticateError(int var1, CharSequence var2);

        public void onAuthenticateFailed();

        public void onAuthenticateHelp(int var1, CharSequence var2);

        public void onAuthenticateSucceeded(FingerprintManagerCompat.AuthenticationResult var1);
    }
}

